-- $Author: fko $
-- $Revision: 1.4 $
-- $Date: 2001/04/26 16:28:52 $

-- Le programme invoker permet de d'invoquer des script CGI crits en shell selon
-- des modalits diverses. Il sert de base au dveloppement de shell_exec (utilis
-- en DEUG MIAS) mais aussi d'autres environnements construits en langage de commande
-- shell.

-- Ce systme est un moteur transformant les rubriques d'un formulaire Internet en
-- des variables d'environnement SHELL. Il invoque ensuite un script dont le nom est
-- fourni via la variable SCRIPT_TO_EXECUTE.

-- Deux procdures permettent d'insrer des traitements 
with TEXT_IO;

generic
   -- Le nom du script instanci
   INVOKE_SYSTEM_NAME : in STRING;
   -- Le nom rpertoire contenant les fichiers temporaires
   TMP_DIR_NAME : in STRING;
   -- Une chane de copyright
   COPYRIGHT : in STRING;
   -- La version courante du script
   SCRIPT_VERSION : in STRING;
   -- La dure limite (confinement) d'excution d'un processus (en secondes CPU)
   DURATION_LIMIT : in STRING;
   -- Savoir si on souhaite avoir des traces ou non
   TRACE_SYSTEM_ON : in out BOOLEAN;
   -- La couleur de fond de la page construite dans les "messages" de shell_exec
   -- en RRVVBB (sans le #)
   BG_COLOR : in STRING;
   -- Le type et la variable dans laquelle on va trouver le script  excuter
   type A_STR is access STRING;
   SCRIPT_TO_EXECUTE : in out A_STR;
   -- Trois procdures pour insrer des aspects spcifiques lors de l'invocation
   -- du script shell:
   -- 1) une procdure qui effectue un traitement avant l'invocation du script shell
   with procedure THINGS_TO_DO_BEFORE;
   -- 2) une procdure permettant d'insrer des instructions shell dans le systme
   --    au debut du script shell CGI
   with procedure ADD_IN_SHELL_INVOCATION_FILE (FILE : in out TEXT_IO.FILE_TYPE);
   -- 3) une procdure permettant d'insrer des instructions shell dans le systme
   --    d'invocation du script shell CGI, juste avant d'executer le script
   --    identifie dans SHELL_EXEC_SCRIPT_TO_EXECUTE 
   with procedure ADD_IN_SHELL_INVOCATION_FILE_RIGHT_BEFORE_INVOKE (FILE : in out TEXT_IO.FILE_TYPE);
   -- 4) une procdure qui effectue des traitements aprs l'invocation du script shell
   with procedure THINGS_TO_DO_AFTER;
package INVOKER is

   ----------------------------------------------------------------------
   -- Une exception pour sortir en urgence (par exemple si les procdures
   -- utilisateurs dtectent une erreur)
   ESCAPE_NOW : exception;
   
   ----------------------------------------------------------------------
   -- Une procedure d'affichage "standard" de petits messages (par exemple
   -- pour les erreurs)
   procedure SEND_SMALL_REPLY (TITLE      : in STRING;
                               MSG_LINE_1 : in STRING;
                               MSG_LINE_2 : in STRING  := "";
                               MSG_LINE_3 : in STRING  := "";
                               MSG_LINE_4 : in STRING  := "";
                               MSG_LINE_5 : in STRING  := "";
                               MSG_LINE_6 : in STRING  := "";
                               DO_ESCAPE  : in BOOLEAN := TRUE);

   ----------------------------------------------------------------------
   -- La procedure qui effectue tout en fonction des paramtres gnriques
   -- de l'unit. On doit invoquer cette procdure pour avoir notre systme
   -- d'invocation de scripts CGI en shell.
   procedure INVOKER_MAIN;

end INVOKER;