-- $Author: fko $
-- $Revision: 1.4 $
-- $Date: 2001/05/11 16:28:52 $

with CGI, TEXT_IO, INVOKER_STRINGS, INVOKER;
use CGI, TEXT_IO, INVOKER_STRINGS;

procedure SHELL_EXEC is

   ----------------------------------------------------------------------
   -- Dfinition des paramtres ncessaires pour invoquer "invoker"

   SHELL_EXEC_SYSTEM_NAME : constant STRING := "shell_exec";
   SHELL_EXEC_COPYRIGHT : constant STRING := "F. Kordon, <A HREF=""www.upmc.fr"">Univ. P. &amp; M. Curie</A>, &copy;08/02/2004";
   SHELL_EXEC_SCRIPT_VERSION : constant STRING := "2.1 (<A HREF=http://www-src.lip6.fr/homepages/Fabrice.Kordon/SOFT/shell_exec-fr.html>t&eacute;l&eacute;charger</A>)";
   SHELL_EXEC_DURATION_LIMIT : constant STRING := "2";
   SHELL_EXEC_TRACE_SYSTEM_ON : BOOLEAN := TRUE;
   SHELL_EXEC_BG_COLOR : constant STRING := "FFF3E7";

   type SHELL_EXEC_A_STRING is access STRING;
   SHELL_EXEC_SCRIPT_TO_EXECUTE : SHELL_EXEC_A_STRING;

   -- Teste la prsence des variables d'environnement de shell_exec
   procedure SHELL_EXEC_THINGS_TO_DO_BEFORE;

   -- Modifie la variable PATH en fonction du contenu de SCRIPT_PATH
   procedure SHELL_EXEC_ADD_IN_SHELL_INVOCATION_FILE (FILE : in out TEXT_IO.FILE_TYPE);
 
   -- Ne fait rien
   procedure SHELL_EXEC_ADD_IN_SHELL_INVOCATION_FILE_RIGHT_BEFORE_INVOKE (FILE : in out TEXT_IO.FILE_TYPE);
 
   -- Ne fait rien
   procedure SHELL_EXEC_THINGS_TO_DO_AFTER;

   package SHELL_EXEC_INVOKER is new INVOKER
      (INVOKE_SYSTEM_NAME           => SHELL_EXEC_SYSTEM_NAME,
       TMP_DIR_NAME                 => "/tmp/",
       COPYRIGHT                    => SHELL_EXEC_COPYRIGHT,
       SCRIPT_VERSION               => SHELL_EXEC_SCRIPT_VERSION,
       DURATION_LIMIT               => SHELL_EXEC_DURATION_LIMIT,
       TRACE_SYSTEM_ON              => SHELL_EXEC_TRACE_SYSTEM_ON,
       BG_COLOR                     => SHELL_EXEC_BG_COLOR,
       A_STR                        => SHELL_EXEC_A_STRING,
       SCRIPT_TO_EXECUTE            => SHELL_EXEC_SCRIPT_TO_EXECUTE,
       THINGS_TO_DO_BEFORE          => SHELL_EXEC_THINGS_TO_DO_BEFORE,
       ADD_IN_SHELL_INVOCATION_FILE => SHELL_EXEC_ADD_IN_SHELL_INVOCATION_FILE,
       ADD_IN_SHELL_INVOCATION_FILE_RIGHT_BEFORE_INVOKE
                                    => SHELL_EXEC_ADD_IN_SHELL_INVOCATION_FILE_RIGHT_BEFORE_INVOKE,
       THINGS_TO_DO_AFTER           => SHELL_EXEC_THINGS_TO_DO_AFTER);

   use SHELL_EXEC_INVOKER;

   ----------------------------------------------------------------------
   -- Implmentation des primitives ainsi dfinies
   
   -- Teste la prsence des variables d'environnement de shell_exec
   procedure SHELL_EXEC_THINGS_TO_DO_BEFORE is
   
   begin
      -- On verifie l'existence des champs ncessaires et des cas de figures
      -- lis  la scurit (interdiction de taper des lignes de commande avec
      -- des paramtres pour viter les trous de scurit: le programme que l'on
      -- invoque doit DEJA exister.
      if VALUE ("SCRIPT_PATH") = "" then
         SEND_SMALL_REPLY (TITLE => "Missing hidden button", MSG_LINE_1 => "<P>Button SCRIPT_PATH has to be defined");
      end if;
      if VALUE ("ADD_PATHS") = "" then
         SEND_SMALL_REPLY (TITLE => "Missing hidden button", MSG_LINE_1 => "<P>Button ADD_PATHS has to be defined");
      end if;
      if (INDEX (TO_VSTRING (VALUE ("SCRIPT_PATH")), TO_VSTRING (ASCII.HT)) /= 0) or else
          (INDEX (TO_VSTRING (VALUE ("SCRIPT_PATH")), TO_VSTRING (' ')) /= 0) or else 
          (INDEX (TO_VSTRING (VALUE ("SCRIPT_PATH")), TO_VSTRING ('>')) /= 0) or else 
          (INDEX (TO_VSTRING (VALUE ("SCRIPT_PATH")), TO_VSTRING ('|')) /= 0) or else 
          (INDEX (TO_VSTRING (VALUE ("SCRIPT_PATH")), TO_VSTRING ('<')) /= 0) or else 
          (INDEX (TO_VSTRING (VALUE ("SCRIPT_PATH")), TO_VSTRING (';')) /= 0) or else 
          (INDEX (TO_VSTRING (VALUE ("SCRIPT_PATH")), TO_VSTRING ("/bin/")) /= 0) or else 
          (INDEX (TO_VSTRING (VALUE ("SCRIPT_PATH")), TO_VSTRING ("/opt/")) /= 0) then
         SEND_SMALL_REPLY (TITLE => "Illegal value for SCRIPT_PATH",
         				   MSG_LINE_1 => "<P>for security reasons, SCRIPT_PATH variable must be a single PATH without parameters",
         				   MSG_LINE_2 => "or unsafe path elements. <P>at least one illegal character or path element has been found and",
         				   MSG_LINE_3 => VALUE ("SCRIPT_PATH") &" cannot be executed as is.");
         raise ESCAPE_NOW;
      end if;
      -- On affecte la valeur de SHELL_EXEC_SCRIPT_TO_EXECUTE
      -- Remarque: merci GNAT VALUE (FIELD)'LAST
      declare
         TMP_VSTRING: VSTRING;
      begin
         TMP_VSTRING := TO_VSTRING (VALUE ("SCRIPT_PATH"));
         SHELL_EXEC_SCRIPT_TO_EXECUTE := new STRING (1.. LENGTH (TMP_VSTRING));
         SHELL_EXEC_SCRIPT_TO_EXECUTE.all := TO_STRING (TMP_VSTRING);
      end;
   end SHELL_EXEC_THINGS_TO_DO_BEFORE;

   -- Modifie la variable PATH en fonction du contenu de SCRIPT_PATH
   procedure SHELL_EXEC_ADD_IN_SHELL_INVOCATION_FILE (FILE : in out TEXT_IO.FILE_TYPE) is
   
   begin
      PUT_LINE (FILE, "PATH=""" & VALUE ("ADD_PATHS") & ":$PATH""");
      PUT_LINE (FILE, "export PATH");
   end SHELL_EXEC_ADD_IN_SHELL_INVOCATION_FILE;

   procedure SHELL_EXEC_ADD_IN_SHELL_INVOCATION_FILE_RIGHT_BEFORE_INVOKE (FILE : in out TEXT_IO.FILE_TYPE) is
   
   begin
      null;
   end SHELL_EXEC_ADD_IN_SHELL_INVOCATION_FILE_RIGHT_BEFORE_INVOKE;

   -- Ne fait rien
   procedure SHELL_EXEC_THINGS_TO_DO_AFTER is
   
   begin
      null;
   end SHELL_EXEC_THINGS_TO_DO_AFTER;

   -----------------------------------------------------------------------------------------
begin -- SHELL_EXEC -- SHELL_EXEC -- SHELL_EXEC -- SHELL_EXEC -- SHELL_EXEC -- SHELL_EXEC --
   -----------------------------------------------------------------------------------------
   INVOKER_MAIN;
end SHELL_EXEC;
