-- $Author: fko $
-- $Revision: 1.4 $
-- $Date: 2001/05/11 16:28:52 $

with CGI, TEXT_IO, INVOKER_STRINGS, SYSTEM, ADA.EXCEPTIONS, GNAT.OS_LIB;
use CGI, TEXT_IO, INVOKER_STRINGS, GNAT.OS_LIB;

package body INVOKER is

   ------------------------------------------------------------------
   -- Constantes
   ------------------------------------------------------------------

   INVOKE_SCRIPT_VERSION : constant STRING := "1.2.1";
   INVOKE_COPYRIGHT      : constant STRING := "F. Kordon, <A HREF=""http://www.upmc.fr"">Univ. P. &amp; M. Curie</A>, &copy;07/10/2003";
   COMMAND_SHELL_PATH    : constant STRING := "/bin/sh";

   ------------------------------------------------------------------
   -- Dclarations globales
   ------------------------------------------------------------------

   -- pour la communication avec Unix
   type OS_INTEGER is  range - 2 ** 31 .. 2 ** 31 - 1;

   -- le file descriptor du fichier que l'on va crer
   FIC : FILE_TYPE;

   ------------------------------------------------------------------
   -- Procdures et fonctions prives
   ------------------------------------------------------------------

   -- La fonction rendant la chane de copyright
   function GET_COPYRIGHT_STRING return STRING is
   
   begin
      return "<FONT SIZE=""-1"" COLOR=""#000000""><CENTER><HR><B>" & INVOKE_SYSTEM_NAME & "</B> version " & SCRIPT_VERSION &
             ", by " & COPYRIGHT & "<BR>" & "based on <B>invoker</B> version " & INVOKE_SCRIPT_VERSION & ", by " &
             INVOKE_COPYRIGHT & "<HR></CENTER></FONT>";
   end GET_COPYRIGHT_STRING;

   -- Fonction qui rend un chemin de fichier temporaire
   function BUILD_TMP_PATH (BASE : in STRING := "tmp_file") return STRING is

      function OS_GET_PID return OS_INTEGER;
      pragma IMPORT (C, OS_GET_PID, "getpid");

   begin
      return TMP_DIR_NAME & "/" & BASE & "." & OS_INTEGER'IMAGE (OS_GET_PID) (2 .. OS_INTEGER'IMAGE (OS_GET_PID)'LAST);
   end BUILD_TMP_PATH;

   ------------------------------------------------------------------
   -- Procdures et fonctions publiques
   ------------------------------------------------------------------

   procedure SEND_SMALL_REPLY (TITLE      : in STRING;
                               MSG_LINE_1 : in STRING;
                               MSG_LINE_2 : in STRING  := "";
                               MSG_LINE_3 : in STRING  := "";
                               MSG_LINE_4 : in STRING  := "";
                               MSG_LINE_5 : in STRING  := "";
                               MSG_LINE_6 : in STRING  := "";
                               DO_ESCAPE  : in BOOLEAN := TRUE) is

   begin
      -- En-tte
      PUT_LINE ("<HTML>");
      PUT_LINE ("<HEAD>");
      PUT_LINE ("   <TITLE>" & INVOKE_SYSTEM_NAME & ": message</TITLE>");
      PUT_LINE ("</HEAD>");
      PUT_LINE ("<BODY BGCOLOR=""#" & BG_COLOR & """>");
      PUT_LINE ("<H2><CENTER>");
      PUT_LINE ("<HR>");
      PUT_LINE ("<FONT COLOR=""#AF0000"">" & INVOKE_SYSTEM_NAME & ":<BR>");
      PUT_LINE (TITLE & "</FONT><HR>");
      PUT_LINE ("</CENTER></H2>");
      -- Contenu
      PUT_LINE (MSG_LINE_1);
      if MSG_LINE_2 /= "" then
         PUT_LINE (MSG_LINE_2);
      end if;
      if MSG_LINE_3 /= "" then
         PUT_LINE (MSG_LINE_3);
      end if;
      if MSG_LINE_4 /= "" then
         PUT_LINE (MSG_LINE_4);
      end if;
      if MSG_LINE_5 /= "" then
         PUT_LINE (MSG_LINE_5);
      end if;
      if MSG_LINE_6 /= "" then
         PUT_LINE (MSG_LINE_6);
      end if;
      -- Pied de page
      PUT_LINE (GET_COPYRIGHT_STRING);
      PUT_LINE ("</BODY>");
      PUT_LINE ("</HTML>");
      if DO_ESCAPE then
         raise ESCAPE_NOW;
      end if;
   end SEND_SMALL_REPLY;

   procedure INVOKER_MAIN is

   begin
      PUT_CGI_HEADER;
      if CGI.INPUT_RECEIVED then
         -- L'UTILISATEUR -------------------------------
         -- Les pr-traitements fournis par l'utilisateur
         THINGS_TO_DO_BEFORE;
         -- INVOKER -------------------------------------
         -- Tout va bien, on prpare la commande shell que l'on va excuter
         begin
            CREATE (FILE => FIC, NAME => BUILD_TMP_PATH);
            if TRACE_SYSTEM_ON then
               PUT_LINE (FIC, "set -x");
            end if;
            -- L'UTILISATEUR -------------------------------
            -- Ajouter les traitements que l'on souhaite insrer en shell
            ADD_IN_SHELL_INVOCATION_FILE (FIC);
            -- INVOKER -------------------------------------
            -- Construire les variables contenant les rubriques du formulaire
            for FIELD in 1 .. ARGUMENT_COUNT loop
               if INDEX (TO_VSTRING (KEY (FIELD)), TO_VSTRING (" ")) /= 0 then
                  SEND_SMALL_REPLY (TITLE      => "Bad button name",
                                    MSG_LINE_1 => "<P>Button name """ & KEY (FIELD) & """ is illegal.",
                                    MSG_LINE_2 => "<P>Button names must contain no space.");
               end if;
               -- Coder le caractere ' car on affecte la variable au moyen d'unne chaine entre '            
               PUT (FIC, KEY (FIELD) & "='");
               -- ca ne marche pas, merci GNAT:for J in VALUE (FIELD)'FIRST.. VALUE (FIELD)'LAST loop
               declare
                  TMP_VSTRING: VSTRING;
               begin
                  TMP_VSTRING := TO_VSTRING (VALUE (FIELD));
                  for J in 1 .. LENGTH (TMP_VSTRING) loop
                     if VALUE (FIELD) (J) = ''' then
                        PUT (FIC, "'""'""'");
                     else
                        PUT (FIC, VALUE (FIELD) (J));
                     end if;
                  end loop;
               end;
               PUT_LINE (FIC, "'");
               PUT_LINE (FIC, "export " & KEY (FIELD));
            end loop;
            declare
               OUT_PUT_REDIRECT : VSTRING;
            begin
               -- L'UTILISATEUR -------------------------------
               -- insertion juste avant d'executer le fichier reference
               ADD_IN_SHELL_INVOCATION_FILE_RIGHT_BEFORE_INVOKE (FIC);
               if SCRIPT_TO_EXECUTE /= null then
                  if TRACE_SYSTEM_ON then
                     PUT_LINE (FIC, "if [ -z ""$ERRORF_PATH"" ] ; then");
                     PUT_LINE (FIC, "   ERRORF2_PATH=""" & BUILD_TMP_PATH (INVOKE_SYSTEM_NAME & "_tmp_errf") & """");
                     PUT_LINE (FIC, "else");
                     PUT_LINE (FIC, "   ERRORF2_PATH=$ERRORF_PATH");
                     PUT_LINE (FIC, "fi");
                     PUT_LINE (FIC, "export ERRORF2_PATH");
                     PUT_LINE (FIC, "tcsh -c 'limit cputime " & DURATION_LIMIT & " ; sh -c """ & SCRIPT_TO_EXECUTE.all & " 2> $ERRORF2_PATH""'");
                  else
                     PUT_LINE (FIC, "tcsh -c 'limit cputime " & DURATION_LIMIT & " ; sh -c """ & SCRIPT_TO_EXECUTE.all & """'");
                  end if;
               end if;
            end;
            if TRACE_SYSTEM_ON then
               PUT_LINE (FIC, "if [ -z ""$ERRORF_PATH"" ] ; then");
               -- On rcupre les informations contenues dans ce fichier temporaire
               -- pour les ressortir au bon format a la fin de l'output
               PUT_LINE (FIC, "echo '<TABLE BORDER=0 BGCOLOR=""#FFCCCC""> <TR> <TD>'");
               PUT_LINE (FIC, "echo ""<CENTER><H2>Traces d'ex&eacute;cution</H2></CENTER></TD> </TR> <TR> <TD>""");
               PUT_LINE (FIC, "echo '<PRE> <FONT COLOR=""#FF0000""> <B>'");
               PUT_LINE (FIC, "sed -e 's/>/\&gt;/g' $ERRORF2_PATH | sed -e 's/</\&lt;/g'");
               PUT_LINE (FIC, "echo '</PRE>'");
               PUT_LINE (FIC, "echo '</FONT> </B> </TD> </TR> </TABLE>'");
               PUT_LINE (FIC, "rm " & BUILD_TMP_PATH (INVOKE_SYSTEM_NAME & "_tmp_errf"));
               PUT_LINE (FIC, "fi");
               --PUT_LINE (FIC, "cp " & BUILD_TMP_PATH & " /home/delbul/the_shell");
            end if;
            CLOSE (FIC);
            -- Excuter le script que l'on vient de crer
            declare
               VRET : BOOLEAN;
               S : String_Access := new String (BUILD_TMP_PATH'RANGE);
               ARG : Argument_List (1 .. 1) := (1 => S);
            begin
               S.all := BUILD_TMP_PATH;
               SPAWN (COMMAND_SHELL_PATH, ARG, VRET);
               if not VRET then
                  PUT_LINE ("<HR><P><B>Attention:</B> probl&egrave;me de chemin ou de droits d'acc&egrave;s.</P>");
                  PUT_LINE ("<P>Consid&eacute;rez en priorit&eacute; les situations suivantes:</P>");
                  PUT_LINE ("<UL><LI>Le chemin <TT>" & VALUE ("SCRIPT_PATH") & "</TT> est correct,");
                  PUT_LINE ("<LI>le fichier <TT>" & VALUE ("SCRIPT_PATH") & "</TT> dispose des droits rwx pour les autres,");
                  PUT_LINE ("<LI>Le chemin <TT>" & VALUE ("ERRORF_PATH") & "</TT> est correct,");
                  PUT_LINE ("<LI>le fichier <TT>" & VALUE ("ERRORF_PATH") & "</TT> dispose des droits rwx pour les autres.");
                  PUT_LINE ("</UL>");
                  PUT_LINE ("<HR><P><B>Warning:</B> Bad path or bad access permission.</P>");
                  PUT_LINE ("<P>Please check first the following situations:</P>");
                  PUT_LINE ("<UL><LI>If path <TT>" & VALUE ("SCRIPT_PATH") & "</TT> is correct,");
                  PUT_LINE ("<LI>If file <TT>" & VALUE ("SCRIPT_PATH") & "</TT> has rwx permission for others,");
                  PUT_LINE ("<LI>If path <TT>" & VALUE ("ERRORF_PATH") & "</TT> is correct,");
                  PUT_LINE ("<LI>If file <TT>" & VALUE ("ERRORF_PATH") & "</TT> has rwx permission for others.");
                  PUT_LINE ("</UL>");
               end if;
            end;
         exception
            when others =>
               DELETE (FIC); -- prcaution
               raise;
         end;
         -- On dtruit le fichier temporaire
         OPEN (FILE => FIC, NAME => BUILD_TMP_PATH, MODE => OUT_FILE);
         DELETE (FIC);
         -- L'UTILISATEUR -------------------------------
         -- Ajouter les traitements que l'on souhaite insrer en shell
         THINGS_TO_DO_AFTER;
         -- INVOKER -------------------------------------
         -- Petit copyright quand-mme:
         PUT_LINE (GET_COPYRIGHT_STRING);
         -- c'est termine
      else
         -- pas d'entre au format CGI, ca sent l'utilisation hors formulaire  plein-nez.
         SEND_SMALL_REPLY (TITLE      => "No input received",
                           MSG_LINE_1 => "<P>" & INVOKE_SYSTEM_NAME & " has not been invoked using an appropriate HTML form.");
      end if;
   
   exception
      when ESCAPE_NOW =>
         null;
      when ERREUR : others =>
         SEND_SMALL_REPLY (TITLE      => "Internal error",
                           MSG_LINE_1 => "Exception " & ADA.EXCEPTIONS.EXCEPTION_NAME (ERREUR) & " raised in shell_maker.cgi");
   end INVOKER_MAIN;
end INVOKER;