-- $Author: fko $
-- $Revision: 1.1.0.1 $
-- $Date: 2001/04/26 16:29:55 $


with VARYING_STRING;

package INVOKER_STRINGS is

   TAILLE_MAX_CHAINE_VARIABLE : constant := 500;

   package INTERNAL_INVOKER_STRINGS is new VARYING_STRING (TAILLE_MAX_CHAINE_VARIABLE);

   -- Le type chaine variables

   subtype VSTRING is INTERNAL_INVOKER_STRINGS.VSTRING;

   -- Le type chaine    

   subtype CSTRING is INTERNAL_INVOKER_STRINGS.CSTRING;

   EMPTY_VSTRING : constant VSTRING := INTERNAL_INVOKER_STRINGS.EMPTY_VSTRING;

   STRING_TOO_LONG        : exception renames INTERNAL_INVOKER_STRINGS.STRING_TOO_LONG;
   VSTRING_TOO_LONG       : exception renames INTERNAL_INVOKER_STRINGS.VSTRING_TOO_LONG;
   VSTRING_INDEX_ERROR    : exception renames INTERNAL_INVOKER_STRINGS.VSTRING_INDEX_ERROR;
   VSTRING_ARGUMENT_ERROR : exception renames INTERNAL_INVOKER_STRINGS.VSTRING_ARGUMENT_ERROR;

   procedure ERASE (VS : out VSTRING) renames INTERNAL_INVOKER_STRINGS.ERASE;

   ----------------------------------------------------------------------
   -- Conversions en VSTRING

   function "=" (V1, V2 : in INVOKER_STRINGS.VSTRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS."=";

   ----------------------------------------------------------------------
   -- Conversions en VSTRING

   function TO_VSTRING (S : in STRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.TO_VSTRING;
   function TO_VSTRING (C : in CHARACTER) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.TO_VSTRING;
   function CSTRING_TO_VSTRING (CS : in CSTRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.
         CSTRING_TO_VSTRING;

   ----------------------------------------------------------------------
   -- Conversion en STRING

   function TO_STRING (VS : in INVOKER_STRINGS.VSTRING) return STRING renames INTERNAL_INVOKER_STRINGS.TO_STRING;

   ----------------------------------------------------------------------
   -- Conversion en CSTRING

   function VSTRING_TO_CSTRING (VS : in INVOKER_STRINGS.VSTRING) return INVOKER_STRINGS.CSTRING renames
      INTERNAL_INVOKER_STRINGS.VSTRING_TO_CSTRING;

   ----------------------------------------------------------------------
   -- Les surcharges de "&"

   function "&" (VS1, VS2 : in INVOKER_STRINGS.VSTRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS."&";
   function "&" (VS : in INVOKER_STRINGS.VSTRING;
                 S  : in STRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS."&";
   function "&" (S  : in STRING;
                 VS : in INVOKER_STRINGS.VSTRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS."&";
   function "&" (S1, S2 : in STRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS."&";
   function "&" (VS : in INVOKER_STRINGS.VSTRING;
                 C  : in CHARACTER) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS."&";
   function "&" (C  : in CHARACTER;
                 VS : in INVOKER_STRINGS.VSTRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS."&";
   function "&" (S : in STRING;
                 C : in CHARACTER) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS."&";
   function "&" (C : in CHARACTER;
                 S : in STRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS."&";
   function "&" (C1, C2 : in CHARACTER) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS."&";
   --function "&" (S  : in STRING;
   --              VS : in INVOKER_STRINGS.VSTRING) return STRING renames INTERNAL_INVOKER_STRINGS."&";
   --function "&" (VS : in INVOKER_STRINGS.VSTRING;
   --              S  : in STRING) return STRING renames INTERNAL_INVOKER_STRINGS."&";

   ----------------------------------------------------------------------
   -- Les surcharges de "<" (ordre lexicographique standard)

   function "<" (VS1, VS2 : in INVOKER_STRINGS.VSTRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS."<";
   function "<" (VS : in INVOKER_STRINGS.VSTRING;
                 S  : in STRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS."<";
   function "<" (S  : in STRING;
                 VS : in INVOKER_STRINGS.VSTRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS."<";

   ----------------------------------------------------------------------
   -- Les surcharges de ">" (ordre lexicographique standard)

   function ">" (VS1, VS2 : in INVOKER_STRINGS.VSTRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS.">";
   function ">" (VS : in INVOKER_STRINGS.VSTRING;
                 S  : in STRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS.">";
   function ">" (S  : in STRING;
                 VS : in INVOKER_STRINGS.VSTRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS.">";

   ----------------------------------------------------------------------
   -- Les surcharges de "<=" (ordre lexicographique standard)

   function "<=" (VS1, VS2 : in INVOKER_STRINGS.VSTRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS."<=";
   function "<=" (VS : in INVOKER_STRINGS.VSTRING;
                  S  : in STRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS."<=";
   function "<=" (S  : in STRING;
                  VS : in INVOKER_STRINGS.VSTRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS."<=";

   ----------------------------------------------------------------------
   -- Les surcharges de ">=" (ordre lexicographique standard)

   function ">=" (VS1, VS2 : in INVOKER_STRINGS.VSTRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS.">=";
   function ">=" (VS : in INVOKER_STRINGS.VSTRING;
                  S  : in STRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS.">=";
   function ">=" (S  : in STRING;
                  VS : in INVOKER_STRINGS.VSTRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS.">=";

   ----------------------------------------------------------------------
   -- Recuperer la longueur d'une Vchaine variable

   function LENGTH (VS : in INVOKER_STRINGS.VSTRING) return NATURAL renames INTERNAL_INVOKER_STRINGS.LENGTH;

   ----------------------------------------------------------------------
   -- Extraire une sous-Vchaine de LEN caracteres a partir
   -- de la position POS
   -- EXEMPLE : SUBSTR ("toto est content", 4, 4) = "o es"

   function SUBSTR (VS       : in INVOKER_STRINGS.VSTRING;
                    POS, LEN : in POSITIVE) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.SUBSTR;
   function SUBSTR (VS       : in INVOKER_STRINGS.VSTRING;
                    POS, LEN : in POSITIVE) return CHARACTER renames INTERNAL_INVOKER_STRINGS.SUBSTR;

   ----------------------------------------------------------------------
   -- Extraire une sous-Vchaine de LEN caracteres en partant
   -- de la gauche de la Vchaine
   -- EXEMPLE : LEFT ("toto est content", 4) = "toto"

   function LEFT (VS  : in INVOKER_STRINGS.VSTRING;
                  LEN : in POSITIVE) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.LEFT;
   function LEFT (VS  : in INVOKER_STRINGS.VSTRING;
                  LEN : in POSITIVE) return CHARACTER renames INTERNAL_INVOKER_STRINGS.LEFT;

   ----------------------------------------------------------------------
   -- Extraire une sous-Vchaine de LEN caracteres en partant
   -- de la droite de la Vchaine
   -- EXEMPLE : RIGHT ("toto est content", 4) = "tent"

   function RIGHT (VS  : in INVOKER_STRINGS.VSTRING;
                   LEN : in POSITIVE) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.RIGHT;
   function RIGHT (VS  : in INVOKER_STRINGS.VSTRING;
                   LEN : in POSITIVE) return CHARACTER renames INTERNAL_INVOKER_STRINGS.RIGHT;

   ----------------------------------------------------------------------
   -- Ramene l'indice de depart de la sous-Vchaine VS2 dans VS1
   -- par convention, 0 signifie : "VS2 n'est pas une sous-Vchaine
   -- de VS1"
   -- EXEMPLE : INDEX ("toto est content", "est") = 6


   function INDEX (VS1, VS2 : in INVOKER_STRINGS.VSTRING) return NATURAL renames INTERNAL_INVOKER_STRINGS.INDEX;

   ----------------------------------------------------------------------
   -- Indique si VS1 contient VS2

   function CONTAINS (VS1, VS2 : in INVOKER_STRINGS.VSTRING) return BOOLEAN renames INTERNAL_INVOKER_STRINGS.CONTAINS;

   ----------------------------------------------------------------------
   -- Suppression des espaces   gauche d'une Vchaine
   -- EXEMPLE : LTRIM ("     toto") = "toto"

   function LTRIM (VS : in INVOKER_STRINGS.VSTRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.LTRIM;

   ----------------------------------------------------------------------
   -- Suppression des espaces   droite d'une Vchaine
   -- EXEMPLE : RTRIM ("toto   ") = "toto"

   function RTRIM (VS : in INVOKER_STRINGS.VSTRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.RTRIM;

   ----------------------------------------------------------------------
   -- Creation d'une Vchaine contenant LEN fois le caractere indique
   -- dans C

   function REPLICATE (C   : in CHARACTER;
                       LEN : in POSITIVE) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.REPLICATE;

   ----------------------------------------------------------------------
   -- Passage en MAJUSCULES du contenu d'une Vchaine

   function UPPER (VS : in INVOKER_STRINGS.VSTRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.UPPER;

   ----------------------------------------------------------------------
   -- Passage en minuscules du contenu d'une Vchaine

   function LOWER (VS : in INVOKER_STRINGS.VSTRING) return INVOKER_STRINGS.VSTRING renames INTERNAL_INVOKER_STRINGS.LOWER;

   ----------------------------------------------------------------------
   -- Pas de surcharge des entrees/sorties car on est cense s'en servir que
   -- dans des cas tres speciaux (encapsulation des E/S)

end INVOKER_STRINGS;
