-- $Author: fko $
-- $Revision: 1.1.0.1 $
-- $Date: 1995/04/26 16:29:55 $


package body VARYING_STRING is

   procedure ERASE (VS : out VSTRING) is

   begin

      VS := EMPTY_VSTRING;

   end ERASE;

   ----------------------------------------------------------------------

   function TO_VSTRING (S : in STRING) return VSTRING is

      RVS : VSTRING;
      L   : NATURAL;

   begin

      L := S'LENGTH;
      if L > VSTRING_SIZE then
         raise STRING_TOO_LONG;
      else
         RVS.L := L;
         if L > 0 then
            RVS.S          := EMPTY_VSTRING.S;
            RVS.S (1 .. L) := S (S'RANGE);
         end if;
         return RVS;
      end if;

   end TO_VSTRING;

   ----------------------------------------------------------------------

   function TO_VSTRING (C : in CHARACTER) return VSTRING is

      RVS : VSTRING;

   begin

      RVS.L     := 1;
      RVS.S     := EMPTY_VSTRING.S;
      RVS.S (1) := C;
      return RVS;

   end TO_VSTRING;

   ----------------------------------------------------------------------

   function CSTRING_TO_VSTRING (CS : in CSTRING) return VSTRING is

      RVS   : VSTRING;
      I     : NATURAL;
      FOUND : BOOLEAN;

   begin

      I     := 1;
      FOUND := FALSE;
      while I <= CS'LENGTH and not FOUND loop
         if CS (I) = ASCII.NUL then
            FOUND := TRUE;
            I     := I - 1;
         else
            I := I + 1;
         end if;
      end loop;
      if I > VSTRING_SIZE then
         raise STRING_TOO_LONG;
      else
         RVS.L := I;
         RVS.S := EMPTY_VSTRING.S;
         if I > 0 then
            RVS.S (1 .. I) := STRING (CS (1 .. I));
         end if;
         return RVS;
      end if;

   end CSTRING_TO_VSTRING;

   ----------------------------------------------------------------------

   function VSTRING_TO_CSTRING (VS : in VSTRING) return CSTRING is

      CS : CSTRING (1 .. VS.L + 1);

   begin

      if VS.L > 0 then
         CS (1 .. VS.L) := CSTRING (VS.S (1 .. VS.L));
      end if;
      CS (VS.L + 1) := ASCII.NUL;
      return CS;

   end VSTRING_TO_CSTRING;

   ----------------------------------------------------------------------

   function TO_STRING (VS : in VSTRING) return STRING is

   begin

      if VS.L = 0 then
         return "";
      else
         return VS.S (1 .. VS.L);
      end if;

   end TO_STRING;

   ----------------------------------------------------------------------

   function "&" (VS1, VS2 : in VSTRING) return VSTRING is

      RVS : VSTRING;

   begin

      if VS1.L + VS2.L > VSTRING_SIZE then
         raise VSTRING_TOO_LONG;
      else
         if VS1.L = 0 then
            return VS2;
         elsif VS2.L = 0 then
            return VS1;
         else
            RVS.L := VS1.L + VS2.L;
            RVS.S := EMPTY_VSTRING.S;
            RVS.S (1 .. VS1.L + VS2.L) := VS1.S (1 .. VS1.L) & VS2.S (1 .. VS2.L);
            return RVS;
         end if;
      end if;

   end "&";

   ----------------------------------------------------------------------

   function "&" (VS : in VSTRING;
                 S  : in STRING) return VSTRING is

   begin

      return VS & TO_VSTRING (S);

   end "&";

   ----------------------------------------------------------------------

   function "&" (S  : in STRING;
                 VS : in VSTRING) return VSTRING is

   begin

      return TO_VSTRING (S) & VS;

   end "&";

   ----------------------------------------------------------------------

   function "&" (S1, S2 : in STRING) return VSTRING is

   begin

      return TO_VSTRING (S1) & TO_VSTRING (S2);

   end "&";

   ----------------------------------------------------------------------

   function "&" (VS : in VSTRING;
                 C  : in CHARACTER) return VSTRING is

   begin

      return VS & TO_VSTRING (C);

   end "&";

   ----------------------------------------------------------------------

   function "&" (C  : in CHARACTER;
                 VS : in VSTRING) return VSTRING is

   begin

      return TO_VSTRING (C) & VS;

   end "&";

   ----------------------------------------------------------------------

   function "&" (S : in STRING;
                 C : in CHARACTER) return VSTRING is

   begin

      return TO_VSTRING (S) & TO_VSTRING (C);

   end "&";

   ----------------------------------------------------------------------

   function "&" (C : in CHARACTER;
                 S : in STRING) return VSTRING is

   begin

      return TO_VSTRING (C) & TO_VSTRING (S);

   end "&";

   ----------------------------------------------------------------------

   function "&" (C1, C2 : in CHARACTER) return VSTRING is

   begin

      return TO_VSTRING (C1) & TO_VSTRING (C2);

   end "&";

   ----------------------------------------------------------------------

   function "&" (S  : in STRING;
                 VS : in VSTRING) return STRING is

   begin
      return TO_STRING (S & VS);
   end "&";

   ----------------------------------------------------------------------

   function "&" (VS : in VSTRING;
                 S  : in STRING) return STRING is

   begin
      return TO_STRING (VS & S);
   end "&";

   ----------------------------------------------------------------------

   function "<" (VS1, VS2 : in VSTRING) return BOOLEAN is

   begin

      if VS1.L = 0 or else VS2.L = 0 then
         return VS1.L = 0;
      else
         return VS1.S (1 .. VS1.L) < VS2.S (1 .. VS2.L);
      end if;

   end "<";

   ----------------------------------------------------------------------

   function "<" (VS : in VSTRING;
                 S  : in STRING) return BOOLEAN is

   begin

      return VS < TO_VSTRING (S);

   end "<";

   ----------------------------------------------------------------------

   function "<" (S  : in STRING;
                 VS : in VSTRING) return BOOLEAN is

   begin

      return TO_VSTRING (S) < VS;

   end "<";

   ----------------------------------------------------------------------

   function ">" (VS1, VS2 : in VSTRING) return BOOLEAN is

   begin

      if VS1.L = 0 or else VS2.L = 0 then
         return VS1.L /= 0;
      else
         return VS1.S (1 .. VS1.L) > VS2.S (1 .. VS2.L);
      end if;

   end ">";

   ----------------------------------------------------------------------

   function ">" (VS : in VSTRING;
                 S  : in STRING) return BOOLEAN is

   begin

      return VS > TO_VSTRING (S);

   end ">";

   ----------------------------------------------------------------------

   function ">" (S  : in STRING;
                 VS : in VSTRING) return BOOLEAN is

   begin

      return TO_VSTRING (S) > VS;

   end ">";

   ----------------------------------------------------------------------

   function "<=" (VS1, VS2 : in VSTRING) return BOOLEAN is

   begin

      return not (VS1 > VS2);

   end "<=";

   ----------------------------------------------------------------------

   function "<=" (VS : in VSTRING;
                  S  : in STRING) return BOOLEAN is

   begin

      return not (VS > S);

   end "<=";

   ----------------------------------------------------------------------

   function "<=" (S  : in STRING;
                  VS : in VSTRING) return BOOLEAN is

   begin

      return not (S > VS);

   end "<=";

   ----------------------------------------------------------------------

   function ">=" (VS1, VS2 : in VSTRING) return BOOLEAN is

   begin

      return not (VS1 < VS2);

   end ">=";

   ----------------------------------------------------------------------

   function ">=" (VS : in VSTRING;
                  S  : in STRING) return BOOLEAN is

   begin

      return not (VS < S);

   end ">=";

   ----------------------------------------------------------------------

   function ">=" (S  : in STRING;
                  VS : in VSTRING) return BOOLEAN is

   begin

      return not (S < VS);

   end ">=";

   ----------------------------------------------------------------------

   function LENGTH (VS : in VSTRING) return NATURAL is

   begin

      return VS.L;

   end LENGTH;

   ----------------------------------------------------------------------

   function SUBSTR (VS       : in VSTRING;
                    POS, LEN : in POSITIVE) return VSTRING is

      RVS : VSTRING;

   begin

      if POS + LEN - 1 > VS.L then
         raise VSTRING_INDEX_ERROR;
      else
         RVS.L            := LEN;
         RVS.S            := EMPTY_VSTRING.S;
         RVS.S (1 .. LEN) := VS.S (POS .. POS + LEN - 1);
         return RVS;
      end if;

   end SUBSTR;

   ----------------------------------------------------------------------

   function SUBSTR (VS       : in VSTRING;
                    POS, LEN : in POSITIVE) return CHARACTER is

   begin

      if LEN /= 1 then
         raise VSTRING_ARGUMENT_ERROR;
      elsif POS > VS.L then
         raise VSTRING_INDEX_ERROR;
      else
         return VS.S (POS);
      end if;

   end SUBSTR;

   ----------------------------------------------------------------------

   function LEFT (VS  : in VSTRING;
                  LEN : in POSITIVE) return VSTRING is

      RVS : VSTRING;

   begin

      if LEN > VS.L then
         raise VSTRING_INDEX_ERROR;
      else
         RVS.L            := LEN;
         RVS.S            := EMPTY_VSTRING.S;
         RVS.S (1 .. LEN) := VS.S (1 .. LEN);
         return RVS;
      end if;

   end LEFT;

   ----------------------------------------------------------------------

   function LEFT (VS  : in VSTRING;
                  LEN : in POSITIVE) return CHARACTER is

   begin

      if LEN /= 1 then
         raise VSTRING_ARGUMENT_ERROR;
      elsif VS.L = 0 then
         raise VSTRING_INDEX_ERROR;
      else
         return VS.S (1);
      end if;

   end LEFT;

   ----------------------------------------------------------------------

   function RIGHT (VS  : in VSTRING;
                   LEN : in POSITIVE) return VSTRING is

      POS : NATURAL;
      RVS : VSTRING;

   begin

      if LEN > VS.L then
         raise VSTRING_INDEX_ERROR;
      else
         RVS.L            := LEN;
         RVS.S            := EMPTY_VSTRING.S;
         POS              := VS.L - LEN + 1;
         RVS.S (1 .. LEN) := VS.S (POS .. VS.L);
         return RVS;
      end if;

   end RIGHT;

   ----------------------------------------------------------------------

   function RIGHT (VS  : in VSTRING;
                   LEN : in POSITIVE) return CHARACTER is

   begin

      if LEN /= 1 then
         raise VSTRING_ARGUMENT_ERROR;
      elsif VS.L = 0 then
         raise VSTRING_INDEX_ERROR;
      else
         return VS.S (VS.L);
      end if;

   end RIGHT;

   ----------------------------------------------------------------------

   function INDEX (VS1, VS2 : in VSTRING) return NATURAL is

      FOUND : BOOLEAN := FALSE;
      I     : NATURAL := 1;

   begin

      while not FOUND and I <= VS1.L - VS2.L + 1 loop
         if VS1.S (I .. I + VS2.L - 1) = VS2.S (1 .. VS2.L) then
            FOUND := TRUE;
         else
            I := I + 1;
         end if;
      end loop;

      if FOUND then
         return I;
      else
         return 0;
      end if;

   end INDEX;

   ----------------------------------------------------------------------

   function CONTAINS (VS1, VS2 : in VSTRING) return BOOLEAN is

   begin

      return INDEX (VS1, VS2) /= 0;

   end CONTAINS;

   ----------------------------------------------------------------------

   function LTRIM (VS : in VSTRING) return VSTRING is

      I   : NATURAL := 1;
      RVS : VSTRING;

   begin

      while I <= VS.L and then VS.S (I) = ' ' loop
         I := I + 1;
      end loop;

      RVS.L := VS.L - I + 1;
      RVS.S := EMPTY_VSTRING.S;

      if RVS.L > 0 then
         RVS.S (1 .. RVS.L) := VS.S (I .. I + RVS.L - 1);
      end if;

      return RVS;

   end LTRIM;

   ----------------------------------------------------------------------

   function RTRIM (VS : in VSTRING) return VSTRING is

      I   : NATURAL := VS.L;
      RVS : VSTRING;

   begin

      while I > 0 and then VS.S (I) = ' ' loop
         I := I - 1;
      end loop;

      RVS.L := I;
      RVS.S := EMPTY_VSTRING.S;

      if RVS.L > 0 then
         RVS.S (1 .. I) := VS.S (1 .. I);
      end if;

      return RVS;

   end RTRIM;

   ----------------------------------------------------------------------

   function REPLICATE (C   : in CHARACTER;
                       LEN : in POSITIVE) return VSTRING is

      RVS : VSTRING;

   begin

      if LEN > VSTRING_SIZE then
         raise VSTRING_INDEX_ERROR;
      else
         RVS.L            := LEN;
         RVS.S            := EMPTY_VSTRING.S;
         RVS.S (1 .. LEN) := (1 .. LEN => C);
         return RVS;
      end if;

   end REPLICATE;

   ----------------------------------------------------------------------

   function UPPER (VS : in VSTRING) return VSTRING is

      RVS : VSTRING;

   begin

      RVS := VS;
      for I in 1 .. RVS.L loop
         if RVS.S (I) >= 'a' and RVS.S (I) <= 'z' then
            RVS.S (I) := CHARACTER'VAL (CHARACTER'POS (RVS.S (I)) - CHARACTER'POS ('a') + CHARACTER'POS ('A'));
         end if;
      end loop;

      return RVS;

   end UPPER;

   ----------------------------------------------------------------------

   function LOWER (VS : in VSTRING) return VSTRING is

      RVS : VSTRING;

   begin

      RVS := VS;
      for I in 1 .. RVS.L loop
         if RVS.S (I) >= 'A' and RVS.S (I) <= 'Z' then
            RVS.S (I) := CHARACTER'VAL (CHARACTER'POS (RVS.S (I)) - CHARACTER'POS ('A') + CHARACTER'POS ('a'));
         end if;
      end loop;

      return RVS;

   end LOWER;

   ----------------------------------------------------------------------

   procedure PUT (FILE  : in FILE_TYPE;
                  VS    : in VSTRING;
                  WIDTH : in NATURAL := 0) is

   begin

      if WIDTH = 0 then
         if VS.L > 0 then
            PUT (FILE, VS.S (1 .. VS.L));
         end if;
      elsif WIDTH <= VS.L then
         PUT (FILE, VS.S (1 .. WIDTH));
      else
         if VS.L > 0 then
            PUT (FILE, VS.S (1 .. VS.L));
         end if;
         PUT (FILE, REPLICATE (' ', WIDTH - VS.L));
      end if;

   end PUT;

   ----------------------------------------------------------------------

   procedure PUT (VS    : in VSTRING;
                  WIDTH : in NATURAL := 0) is

   begin

      if WIDTH = 0 then
         if VS.L > 0 then
            PUT (VS.S (1 .. VS.L));
         end if;
      elsif WIDTH <= VS.L then
         PUT (VS.S (1 .. WIDTH));
      else
         if VS.L > 0 then
            PUT (VS.S (1 .. VS.L));
         end if;
         PUT (REPLICATE (' ', WIDTH - VS.L));
      end if;

   end PUT;

   ----------------------------------------------------------------------

   procedure PUT_LINE (FILE  : in FILE_TYPE;
                       VS    : in VSTRING;
                       WIDTH : in NATURAL := 0) is

   begin

      PUT (FILE, VS, WIDTH);
      NEW_LINE (FILE);

   end PUT_LINE;

   ----------------------------------------------------------------------

   procedure PUT_LINE (VS    : in VSTRING;
                       WIDTH : in NATURAL := 0) is

   begin

      PUT (VS, WIDTH);
      NEW_LINE;

   end PUT_LINE;

   ----------------------------------------------------------------------

   procedure GET (FILE : in FILE_TYPE;
                  VS   : out VSTRING) is

   begin

      VS.S := EMPTY_VSTRING.S;
      GET_LINE (FILE, VS.S, VS.L);

   end GET;

   ----------------------------------------------------------------------

   procedure GET (VS : out VSTRING) is

   begin

      VS.S := EMPTY_VSTRING.S;
      GET_LINE (VS.S, VS.L);

   end GET;

end VARYING_STRING;
