-- $Author: fko $
-- $Revision: 1.1.0.1 $
-- $Date: 1995/04/26 16:29:55 $

----------------------------------------------------------------------
-- Unite de gestion de chaines de taille variables (jusqu'a une
-- longueur maximale specifiee a l'aide du parametre generique formel)
----------------------------------------------------------------------
-- Cette unite a ete developpe par Remy Card (1990) et mise a jour
-- par F.Kordon (1993).
----------------------------------------------------------------------

with TEXT_IO; -- Normal (sinon, on perd l'aspect general de VARYING_STRING)
use TEXT_IO;

generic
   VSTRING_SIZE : in POSITIVE := 255;

package VARYING_STRING is

   -- Type decrivant une Vchaine de longueur variable

   type VSTRING is private;

   -- type decrivant une chaine au "format C" (terminee par un \0)

   type CSTRING is new STRING;

   -- La constante "Vchaine vide"

   EMPTY_VSTRING : constant VSTRING;

   -- Des exceptions pour signaler les erreurs

   STRING_TOO_LONG        : exception;
   VSTRING_TOO_LONG       : exception;
   VSTRING_INDEX_ERROR    : exception;
   VSTRING_ARGUMENT_ERROR : exception;

   ----------------------------------------------------------------------
   -- remettre une VSTRING a la valeur EMPTY_VSTRING

   procedure ERASE (VS : out VSTRING);

   ----------------------------------------------------------------------
   -- Conversions en VSTRING

   function TO_VSTRING (S : in STRING) return VSTRING;
   function TO_VSTRING (C : in CHARACTER) return VSTRING;
   function CSTRING_TO_VSTRING (CS : in CSTRING) return VSTRING;

   ----------------------------------------------------------------------
   -- Conversion en STRING

   function TO_STRING (VS : in VSTRING) return STRING;

   ----------------------------------------------------------------------
   -- Conversion en CSTRING

   function VSTRING_TO_CSTRING (VS : in VSTRING) return CSTRING;

   ----------------------------------------------------------------------
   -- Les surcharges de "&"

   function "&" (VS1, VS2 : in VSTRING) return VSTRING;
   function "&" (VS : in VSTRING;
                 S  : in STRING) return VSTRING;
   function "&" (S  : in STRING;
                 VS : in VSTRING) return VSTRING;
   function "&" (S1, S2 : in STRING) return VSTRING;
   function "&" (VS : in VSTRING;
                 C  : in CHARACTER) return VSTRING;
   function "&" (C  : in CHARACTER;
                 VS : in VSTRING) return VSTRING;
   function "&" (S : in STRING;
                 C : in CHARACTER) return VSTRING;
   function "&" (C : in CHARACTER;
                 S : in STRING) return VSTRING;
   function "&" (C1, C2 : in CHARACTER) return VSTRING;
   --function "&" (S  : in STRING;
   --              VS : in VSTRING) return STRING;
   --function "&" (VS : in VSTRING;
   --              S  : in STRING) return STRING;

   ----------------------------------------------------------------------
   -- Les surcharges de "<" (ordre lexicographique standard)

   function "<" (VS1, VS2 : in VSTRING) return BOOLEAN;
   function "<" (VS : in VSTRING;
                 S  : in STRING) return BOOLEAN;
   function "<" (S  : in STRING;
                 VS : in VSTRING) return BOOLEAN;

   ----------------------------------------------------------------------
   -- Les surcharges de ">" (ordre lexicographique standard)

   function ">" (VS1, VS2 : in VSTRING) return BOOLEAN;
   function ">" (VS : in VSTRING;
                 S  : in STRING) return BOOLEAN;
   function ">" (S  : in STRING;
                 VS : in VSTRING) return BOOLEAN;

   ----------------------------------------------------------------------
   -- Les surcharges de "<=" (ordre lexicographique standard)

   function "<=" (VS1, VS2 : in VSTRING) return BOOLEAN;
   function "<=" (VS : in VSTRING;
                  S  : in STRING) return BOOLEAN;
   function "<=" (S  : in STRING;
                  VS : in VSTRING) return BOOLEAN;

   ----------------------------------------------------------------------
   -- Les surcharges de ">=" (ordre lexicographique standard)

   function ">=" (VS1, VS2 : in VSTRING) return BOOLEAN;
   function ">=" (VS : in VSTRING;
                  S  : in STRING) return BOOLEAN;
   function ">=" (S  : in STRING;
                  VS : in VSTRING) return BOOLEAN;

   ----------------------------------------------------------------------
   -- Recuperer la longueur d'une Vchaine variable

   function LENGTH (VS : in VSTRING) return NATURAL;

   ----------------------------------------------------------------------
   -- Extraire une sous-Vchaine de LEN caracteres a partir
   -- de la position POS
   -- EXEMPLE : SUBSTR ("toto est content", 4, 4) = "o es"

   function SUBSTR (VS       : in VSTRING;
                    POS, LEN : in POSITIVE) return VSTRING;
   function SUBSTR (VS       : in VSTRING;
                    POS, LEN : in POSITIVE) return CHARACTER;

   ----------------------------------------------------------------------
   -- Extraire une sous-Vchaine de LEN caracteres en partant
   -- de la gauche de la Vchaine
   -- EXEMPLE : LEFT ("toto est content", 4) = "toto"

   function LEFT (VS  : in VSTRING;
                  LEN : in POSITIVE) return VSTRING;
   function LEFT (VS  : in VSTRING;
                  LEN : in POSITIVE) return CHARACTER;

   ----------------------------------------------------------------------
   -- Extraire une sous-Vchaine de LEN caracteres en partant
   -- de la droite de la Vchaine
   -- EXEMPLE : RIGHT ("toto est content", 4) = "tent"

   function RIGHT (VS  : in VSTRING;
                   LEN : in POSITIVE) return VSTRING;
   function RIGHT (VS  : in VSTRING;
                   LEN : in POSITIVE) return CHARACTER;

   ----------------------------------------------------------------------
   -- Ramene l'indice de depart de la sous-Vchaine VS2 dans VS1
   -- par convention, 0 signifie : "VS2 n'est pas une sous-Vchaine
   -- de VS1"
   -- EXEMPLE : INDEX ("toto est content", "est") = 6


   function INDEX (VS1, VS2 : in VSTRING) return NATURAL;

   ----------------------------------------------------------------------
   -- Indique si VS1 contient VS2

   function CONTAINS (VS1, VS2 : in VSTRING) return BOOLEAN;

   ----------------------------------------------------------------------
   -- Suppression des espaces   gauche d'une Vchaine
   -- EXEMPLE : LTRIM ("     toto") = "toto"

   function LTRIM (VS : in VSTRING) return VSTRING;

   ----------------------------------------------------------------------
   -- Suppression des espaces   droite d'une Vchaine
   -- EXEMPLE : RTRIM ("toto   ") = "toto"

   function RTRIM (VS : in VSTRING) return VSTRING;

   ----------------------------------------------------------------------
   -- Creation d'une Vchaine contenant LEN fois le caractere indique
   -- dans C

   function REPLICATE (C   : in CHARACTER;
                       LEN : in POSITIVE) return VSTRING;

   ----------------------------------------------------------------------
   -- Passage en MAJUSCULES du contenu d'une Vchaine

   function UPPER (VS : in VSTRING) return VSTRING;

   ----------------------------------------------------------------------
   -- Passage en minuscules du contenu d'une Vchaine

   function LOWER (VS : in VSTRING) return VSTRING;

   ----------------------------------------------------------------------
   -- Surcharge des entrees/sorties

   procedure PUT (FILE  : in FILE_TYPE;
                  VS    : in VSTRING;
                  WIDTH : in NATURAL := 0);
   procedure PUT (VS    : in VSTRING;
                  WIDTH : in NATURAL := 0);


   procedure PUT_LINE (FILE  : in FILE_TYPE;
                       VS    : in VSTRING;
                       WIDTH : in NATURAL := 0);
   procedure PUT_LINE (VS    : in VSTRING;
                       WIDTH : in NATURAL := 0);


   procedure GET (FILE : in FILE_TYPE;
                  VS   : out VSTRING);
   procedure GET (VS : out VSTRING);

   procedure GET_LINE (FILE : in FILE_TYPE;
                       VS   : out VSTRING) renames GET;
   procedure GET_LINE (VS : out VSTRING) renames GET;

private

   type VSTRING is
      record
         L : NATURAL                    := 0;
         S : STRING (1 .. VSTRING_SIZE) := (1 .. VSTRING_SIZE => ASCII.NUL);
      end record;

   EMPTY_VSTRING : constant VSTRING := (L => 0, S => (1 .. VSTRING_SIZE => ASCII.NUL));

end VARYING_STRING;
